<?php
require_once 'config.php';
require_once 'auth.php';
require_login();

// Crear / editar pantalla
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $name = trim($_POST['name'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $resolution = trim($_POST['resolution'] ?? '');
    $active = isset($_POST['active']) ? 1 : 0;

    if ($name !== '') {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE screens SET name=?, location=?, resolution=?, active=?, updated_at=strftime('%s','now') WHERE id=?");
            $stmt->execute([$name, $location, $resolution, $active, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO screens (name, location, resolution, active) VALUES (?, ?, ?, ?)");
            $stmt->execute([$name, $location, $resolution, $active]);
        }
    }

    header('Location: screens.php');
    exit;
}

// Eliminar pantalla
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM media WHERE screen_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM screens WHERE id=?")->execute([$id]);
    header('Location: screens.php');
    exit;
}

// Editar
$editScreen = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM screens WHERE id=?");
    $stmt->execute([$id]);
    $editScreen = $stmt->fetch(PDO::FETCH_ASSOC);
}

$screens = $pdo->query("SELECT * FROM screens ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Pantallas - PRISA DOOH</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body class="admin-body">
<?php include 'topbar.php'; ?>
<div class="admin-container">
    <div class="admin-header">
        <div>
            <h1>Pantallas</h1>
            <p>Administrá el inventario de pantallas del circuito PRISA DOOH.</p>
        </div>
        <div class="admin-header-actions">
            <span class="hint">Tip: usá el botón "Monitor" en Creatividades para ver la pantalla en vivo.</span>
        </div>
    </div>

    <div class="grid-2">
        <div class="card">
            <h2><?php echo $editScreen ? 'Editar pantalla' : 'Nueva pantalla'; ?></h2>
            <form method="post" class="form">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($editScreen['id'] ?? ''); ?>">
                <label>Nombre
                    <input type="text" name="name" required placeholder="Ej: LED Villa Crespo" value="<?php echo htmlspecialchars($editScreen['name'] ?? ''); ?>">
                </label>
                <label>Ubicación
                    <input type="text" name="location" placeholder="Ej: Av. Corrientes y Humboldt" value="<?php echo htmlspecialchars($editScreen['location'] ?? ''); ?>">
                </label>
                <label>Resolución
                    <input type="text" name="resolution" placeholder="Ej: 960x576 px" value="<?php echo htmlspecialchars($editScreen['resolution'] ?? ''); ?>">
                </label>
                <label class="checkbox">
                    <input type="checkbox" name="active" <?php echo (isset($editScreen['active']) ? ( $editScreen['active'] ? 'checked' : '') : 'checked'); ?>>
                    Pantalla activa
                </label>
                <button type="submit" class="btn-primary"><?php echo $editScreen ? 'Guardar cambios' : 'Crear pantalla'; ?></button>
            </form>
        </div>

        <div class="card">
            <h2>Listado de pantallas</h2>
            <?php if (!$screens): ?>
                <p>No hay pantallas cargadas todavía.</p>
            <?php else: ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Pantalla</th>
                            <th>Ubicación</th>
                            <th>Resolución</th>
                            <th>Estado</th>
                            <th>Player</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($screens as $s): ?>
                        <tr>
                            <td>#<?php echo $s['id']; ?></td>
                            <td><?php echo htmlspecialchars($s['name']); ?></td>
                            <td><?php echo htmlspecialchars($s['location']); ?></td>
                            <td><?php echo htmlspecialchars($s['resolution']); ?></td>
                            <td>
                                <?php if ($s['active']): ?>
                                    <span class="badge badge-success">Activa</span>
                                <?php else: ?>
                                    <span class="badge">Inactiva</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="player.php?screen_id=<?php echo $s['id']; ?>" target="_blank" class="link">
                                    Abrir player
                                </a>
                            </td>
                            <td class="table-actions">
                                <a href="media.php?screen_id=<?php echo $s['id']; ?>" class="btn-small">Creatividades</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
</body>
</html>
