<?php
require_once 'config.php';

header('Content-Type: application/json; charset=utf-8');

$screenId = isset($_GET['screen_id']) ? (int)$_GET['screen_id'] : 0;
if (!$screenId) {
    echo json_encode(['error' => 'screen_id requerido']);
    exit;
}

$since = isset($_GET['since']) ? (int)$_GET['since'] : 0;

// Última actualización real
$stmt = $pdo->prepare("SELECT MAX(updated_at) AS last_update FROM media WHERE screen_id=? AND active=1");
$stmt->execute([$screenId]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
$lastUpdate = (int)($row['last_update'] ?? 0);

if ($lastUpdate <= $since && $since !== 0) {
    echo json_encode([
        'changed' => false,
        'last_update' => $lastUpdate,
        'items' => []
    ]);
    exit;
}

// Playlist completa
$stmt = $pdo->prepare("SELECT * FROM media WHERE screen_id=? AND active=1 ORDER BY sort_order ASC, id ASC");
$stmt->execute([$screenId]);
$media = $stmt->fetchAll(PDO::FETCH_ASSOC);

$items = [];
foreach ($media as $m) {
    $url = $m['external_url'] ?: ('uploads/' . $m['file_name']);
    $items[] = [
        'id' => (int)$m['id'],
        'type' => $m['type'],
        'url' => $url,
        'duration' => (int)$m['duration'],
        'advertiser' => $m['advertiser'] ?? ''
    ];
}

echo json_encode([
    'changed' => true,
    'last_update' => $lastUpdate,
    'items' => $items
]);
